/*********************************************
	USBScope data file reader demo
	www.sunlogics.co.kr
	2012.01.18	SY Jang
*********************************************/
#include <windows.h>
#include <time.h>
#include <stdio.h>
#include <conio.h>


/////////////////////////////////////////////////////////////
#pragma pack(push,1)		// for Visual C++ 6.0

typedef struct _WORDDATA {
	BYTE	ch1;
	BYTE	ch2;
} WORDDATA;

typedef struct {
	DWORD		marker;
	DWORD		cbSize;
	time_t		date;
	double		frequency;
	BYTE		channels;
	DWORD		length;
	DWORD		reserved0;
	DWORD		reserved1;
	DWORD		reserved2;
	DWORD		reserved3;
	DWORD		reserved4;
} DSO_HEADER;

#pragma pack(pop)			// for Visual C++ 6.0
/////////////////////////////////////////////////////////////

#define SCOPE_MARKER_V1		(('1'<<24) | ('O'<<16) | ('S'<<8) | 'D')

#define DATA2VOLT(y)		((y - 0x80) * 0.0768)


BOOL loadData(LPCTSTR lpPath);


int main(int argc, char* argv[])
{
	loadData("sample.dso");
	getch();
	return 0;
}


BOOL loadData(LPCTSTR lpPath)
{
	DSO_HEADER	dsoHeader;
	FILE		*fp;
	DWORD		samples;
	double		ch1Mean, ch2Mean;
	BYTE		*buf=NULL;

	fp = fopen(lpPath, "rb");
	if(fp == NULL)	{	printf("Cannot open file!");	return FALSE;	}

	fread(&dsoHeader, sizeof(char), sizeof(DSO_HEADER), fp);
	if(dsoHeader.marker != SCOPE_MARKER_V1)	{	fclose(fp);	printf("Unkown or currupted file!");	return FALSE;}

	buf = new BYTE[dsoHeader.length];
	if(buf == NULL)	{fclose(fp);	printf("memory error!");	return FALSE;}

	fread(buf, sizeof(char), dsoHeader.length, fp);
	fclose(fp);

	//----------------------------------------------------
	// print information
	//----------------------------------------------------
	printf("Sample channels: %d ch\n", dsoHeader.channels);
	printf("Sample frequency: %.0f Hz\n", dsoHeader.frequency);
	printf("Sample time: %s", ctime(&dsoHeader.date));
	printf("Sample size: %d bytes\n", dsoHeader.length);

	//----------------------------------------------------
	// show mean values
	//----------------------------------------------------
	ch1Mean = ch2Mean = 0.0;
	if(dsoHeader.channels == 2)
	{
		WORDDATA	*pWord = (WORDDATA*)buf;

		samples = dsoHeader.length / 2;
		for(DWORD i=0; i<samples; i++)
		{
			ch1Mean += DATA2VOLT(pWord->ch1);
			ch2Mean += DATA2VOLT(pWord->ch2);
			pWord++;
		}

		ch1Mean = ch1Mean / samples;
		ch2Mean = ch2Mean / samples;
	}
	else
	{
		BYTE	*pByte = buf;

		samples = dsoHeader.length;
		for(DWORD i=0; i<samples; i++)
		{
			ch1Mean += DATA2VOLT(*pByte);
			pByte++;
		}

		ch1Mean = ch1Mean / samples;
	}
	printf("CH1 mean: %.2fV, CH2 mean: %.2fV\n", ch1Mean, ch2Mean);

	//----------------------------------------------------
	// release buffer
	//----------------------------------------------------
	delete [] buf;

	return TRUE;
}


