#include "usbscope_sdk.h"


HINSTANCE	g_hUsbDll = NULL;

int (__cdecl *USB_RegisterDevice)();
int (__cdecl *USB_FindDevice)();
int (__cdecl *USB_Detect)(int index);
int (__cdecl *USB_Open)(HWND hWnd, int index);
void (__cdecl *USB_Close)();
BOOL (__cdecl *USB_IsOpen)();
BOOL (__cdecl *USB_IsHighSpeed)();
HANDLE (__cdecl *USB_GetHandle)();
BOOL (__cdecl *USB_ADChannel2_Enable)(BOOL bADC2Enable);
BOOL (__cdecl *USB_IsADChannel2_Enable)();
BOOL (__cdecl *USB_Read)(BYTE *readBuf, DWORD length);
BOOL (__cdecl *USB_ReadLoop)(DWORD length, BYTE *pBufA, BYTE *pBufB, HANDLE hEvtA, HANDLE hEvtB, BOOL *pbStopFlag);
char* (__cdecl *USB_GetErrorString)();
double (__cdecl *USB_HW_Frequency)();
int (__cdecl *USB_HW_AnalogChannels)();
int (__cdecl *USB_HW_DigitalChannels)();
char* (__cdecl *USB_ModelName)();
void (__cdecl *USB_Change_HW_Frequency)(double frequency);
int (__cdecl *USB_Active_AnalogChannels)();

double (__cdecl *UTIL_GetAvailableSampleTime)(DWORD buffer_size, int analog_channels, double capure_frequency);
DWORD (__cdecl *UTIL_GetRequiredBytes)(double capture_time, int analog_channels, double capure_frequency);
void (__cdecl *UTIL_Set_SW_Frequency)(double frequency);
void (__cdecl *UTIL_DownSampling)(BYTE *buffer, DWORD buflen, int analog_channels, int nDownRate);
double (__cdecl *UTIL_GetSampleTime)(DWORD sampleIndex);
DWORD (__cdecl *UTIL_GetFreeMemory)();

BOOL (__cdecl *FILE_SaveScope)(BYTE *buffer, DWORD buffLen, int analog_channels, double frequency, char* path);
DWORD (__cdecl *FILE_LoadScope)(BYTE *pBuf, char* path);
DSO_HEADER* (__cdecl *FILE_GetScopeHeader)();
BOOL (__cdecl *FILE_SaveLogic)(BYTE *buffer, DWORD buffLen, int analog_channels, double frequency, char* path);
DWORD (__cdecl *FILE_LoadLogic)(BYTE *pBuf, char* path);
LGA_HEADER* (__cdecl *FILE_GetLogicHeader)();


#define LOAD_FUNC(func, name, type)		func = (type) GetProcAddress(g_hUsbDll, name);	\
										if(func == NULL)	return FALSE;


BOOL LoadUSBScopeDLL()
{
	g_hUsbDll = LoadLibrary("usbscope_s102.dll");
	//g_hUsbDll = LoadLibrary("usbscope_s202.dll");
	//g_hUsbDll = LoadLibrary("usbscope_s401.dll");
	//g_hUsbDll = LoadLibrary("usbscope_sl102.dll");
	//g_hUsbDll = LoadLibrary("usbscope_sl202.dll");
	//g_hUsbDll = LoadLibrary("usbscope_sl401.dll");
	if(g_hUsbDll == NULL)
	{
		MessageBox(NULL, "usbscope_s102.dll load err!", "Error", MB_ICONSTOP | MB_OK);
		return FALSE;
	}

	LOAD_FUNC(USB_RegisterDevice, "USB_RegisterDevice", int (__cdecl *)());
	LOAD_FUNC(USB_FindDevice, "USB_FindDevice", int (__cdecl *)());
	LOAD_FUNC(USB_Detect, "USB_Detect", int (__cdecl *)(int));
	LOAD_FUNC(USB_Open, "USB_Open", int (__cdecl *)(HWND, int));
	LOAD_FUNC(USB_Close, "USB_Close", void (__cdecl *)());
	LOAD_FUNC(USB_IsOpen, "USB_IsOpen", BOOL (__cdecl *)());
	LOAD_FUNC(USB_IsHighSpeed, "USB_IsHighSpeed", BOOL (__cdecl *)());
	LOAD_FUNC(USB_GetHandle, "USB_GetHandle", HANDLE (__cdecl *)());
	LOAD_FUNC(USB_ADChannel2_Enable, "USB_ADChannel2_Enable", BOOL (__cdecl *)(BOOL));
	LOAD_FUNC(USB_IsADChannel2_Enable, "USB_IsADChannel2_Enable", BOOL (__cdecl *)());
	LOAD_FUNC(USB_Read, "USB_Read", BOOL (__cdecl *)(BYTE*, DWORD));
	LOAD_FUNC(USB_ReadLoop, "USB_ReadLoop", BOOL (__cdecl *)(DWORD length, BYTE *pBufA, BYTE *pBufB, HANDLE hEvtA, HANDLE hEvtB, BOOL *pbStopFlag));
	LOAD_FUNC(USB_GetErrorString, "USB_GetErrorString", char* (__cdecl *)());
	LOAD_FUNC(USB_HW_Frequency, "USB_HW_Frequency", double (__cdecl *)());
	LOAD_FUNC(USB_HW_AnalogChannels, "USB_HW_AnalogChannels", int (__cdecl *)());
	LOAD_FUNC(USB_HW_DigitalChannels, "USB_HW_DigitalChannels", int (__cdecl *)());
	LOAD_FUNC(USB_ModelName, "USB_ModelName", char* (__cdecl *)());
	LOAD_FUNC(USB_Change_HW_Frequency, "USB_Change_HW_Frequency", void (__cdecl *)(double));
	LOAD_FUNC(USB_Active_AnalogChannels, "USB_Active_AnalogChannels", int (__cdecl *)());

	LOAD_FUNC(UTIL_GetAvailableSampleTime, "UTIL_GetAvailableSampleTime", double (__cdecl *)(DWORD, int, double));
	LOAD_FUNC(UTIL_GetRequiredBytes, "UTIL_GetRequiredBytes", DWORD (__cdecl *)(double, int, double));
	LOAD_FUNC(UTIL_Set_SW_Frequency, "UTIL_Set_SW_Frequency", void (__cdecl *)(double));
	LOAD_FUNC(UTIL_DownSampling, "UTIL_DownSampling", void (__cdecl *)(BYTE*, DWORD, int, int));
	LOAD_FUNC(UTIL_GetSampleTime, "UTIL_GetSampleTime", double (__cdecl *)(DWORD));
	LOAD_FUNC(UTIL_GetFreeMemory, "UTIL_GetFreeMemory", DWORD (__cdecl *)());

	LOAD_FUNC(FILE_SaveScope, "FILE_SaveScope", BOOL (__cdecl *)(BYTE*, DWORD, int, double, char*));
	LOAD_FUNC(FILE_LoadScope, "FILE_LoadScope", DWORD (__cdecl *)(BYTE*, char*));
	LOAD_FUNC(FILE_GetScopeHeader, "FILE_GetScopeHeader", DSO_HEADER* (__cdecl *)());
	LOAD_FUNC(FILE_SaveLogic, "FILE_SaveLogic", BOOL (__cdecl *)(BYTE*, DWORD, int, double, char*));
	LOAD_FUNC(FILE_LoadLogic, "FILE_LoadLogic", DWORD (__cdecl *)(BYTE*, char*));
	LOAD_FUNC(FILE_GetLogicHeader, "FILE_GetLogicHeader", LGA_HEADER* (__cdecl *)());

	return TRUE;
}


void UnLoadUSBScopeDLL()
{
	if(g_hUsbDll)
		FreeLibrary(g_hUsbDll);
	g_hUsbDll = NULL;
}


