#ifndef ___USBSCOPE_SDK___
#define ___USBSCOPE_SDK___


#include <windows.h>
#include <time.h>

#define READ_BLOCK					65536

// for USB_Detect()
#define USBSTATUS_ATTACHED			1

// for USB_Open()
#define USBSTATUS_CONNECTED			1
#define USBSTATUS_NOTFOUND			-1
#define USBSTATUS_NOLICENSE			-2


// voltage <--> data
#define DATA2VOLT(y)	(double)((y - 0x80) * 0.0768)		// = y * 20V / 268
#define VOLT2DATA(v)	(BYTE)((v / 0.0768) + 0x80)


/////////////////////////////////////////////////////////////
#pragma pack(push,1)	// for Visual C++ 6.0

typedef struct _WORDDATA {
	BYTE		ch1;
	BYTE		ch2;
} WORDDATA;

typedef struct {
	DWORD		marker;
	DWORD		cbSize;
	time_t		date;
	double		frequency;
	BYTE		channels;
	DWORD		length;
	DWORD		reserved0;
	DWORD		reserved1;
	DWORD		reserved2;
	DWORD		reserved3;
	DWORD		reserved4;
} DSO_HEADER;

typedef struct {
	DWORD		marker;
	DWORD		cbSize;
	time_t		date;
	double		frequency;
	BYTE		channels;
	WORD		enabled;
	char		names[16][16];
	WORD		chbits[16];
	BYTE		protocol[16];
	WORD		edgemode;
	DWORD		length;
	DWORD		reserved0;
	DWORD		reserved1;
	DWORD		reserved2;
	DWORD		reserved3;
	DWORD		reserved4;
} LGA_HEADER;

#pragma pack(pop)			// for Visual C++ 6.0
/////////////////////////////////////////////////////////////


#define SCOPE_MARKER_V1		(('1'<<24) | ('O'<<16) | ('S'<<8) | 'D')
#define LOGIC_MARKER_V0		(('0'<<24) | ('A'<<16) | ('G'<<8) | 'L')



//****************************************************************
//	USB Functions
//****************************************************************

extern int (__cdecl *USB_RegisterDevice)();
extern int (__cdecl *USB_FindDevice)();
extern int (__cdecl *USB_Detect)(int index);
extern int (__cdecl *USB_Open)(HWND hWnd, int index);
extern void (__cdecl *USB_Close)();
extern BOOL (__cdecl *USB_IsOpen)();
extern BOOL (__cdecl *USB_IsHighSpeed)();
extern HANDLE (__cdecl *USB_GetHandle)();
extern BOOL (__cdecl *USB_ADChannel2_Enable)(BOOL bADC2Enable);
extern BOOL (__cdecl *USB_IsADChannel2_Enable)();
extern BOOL (__cdecl *USB_Read)(BYTE *readBuf, DWORD length);
extern BOOL (__cdecl *USB_ReadLoop)(DWORD length, BYTE *pBufA, BYTE *pBufB, HANDLE hEvtA, HANDLE hEvtB, BOOL *pbStopFlag);
extern char* (__cdecl *USB_GetErrorString)();
extern double (__cdecl *USB_HW_Frequency)();
extern int (__cdecl *USB_HW_AnalogChannels)();
extern int (__cdecl *USB_HW_DigitalChannels)();
extern char* (__cdecl *USB_ModelName)();
extern void (__cdecl *USB_Change_HW_Frequency)(double frequency);
extern int (__cdecl *USB_Active_AnalogChannels)();


//****************************************************************
//	Utility Functions
//****************************************************************

extern double (__cdecl *UTIL_GetAvailableSampleTime)(DWORD buffer_size, int analog_channels, double capure_frequency);
extern DWORD (__cdecl *UTIL_GetRequiredBytes)(double capture_time, int analog_channels, double capure_frequency);
extern void (__cdecl *UTIL_Set_SW_Frequency)(double frequency);
extern void (__cdecl *UTIL_DownSampling)(BYTE *buffer, DWORD buflen, int analog_channels, int nDownRate);
extern double (__cdecl *UTIL_GetSampleTime)(DWORD sampleIndex);
extern DWORD (__cdecl *UTIL_GetFreeMemory)();


//****************************************************************
//	Data File Functions
//****************************************************************

extern BOOL (__cdecl *FILE_SaveScope)(BYTE *buffer, DWORD buffLen, int analog_channels, double frequency, char* path);
extern DWORD (__cdecl *FILE_LoadScope)(BYTE *pBuf, char* path);
extern DSO_HEADER* (__cdecl *FILE_GetScopeHeader)();
extern BOOL (__cdecl *FILE_SaveLogic)(BYTE *buffer, DWORD buffLen, int analog_channels, double frequency, char* path);
extern DWORD (__cdecl *FILE_LoadLogic)(BYTE *pBuf, char* path);
extern LGA_HEADER* (__cdecl *FILE_GetLogicHeader)();


#endif	//___USBSCOPE_SDK___

