#ifndef ___USBSCOPE_DLL___
#define ___USBSCOPE_DLL___


#ifdef USBSCOPE_EXPORTS
#define USBSCOPE_API __declspec(dllexport)
#else
#define USBSCOPE_API __declspec(dllimport)
#endif


#include <windows.h>
#include <time.h>

#define READ_BLOCK					65536

// for USB_Detect()
#define USBSTATUS_ATTACHED			1

// for USB_Open()
#define USBSTATUS_CONNECTED			1
#define USBSTATUS_NOTFOUND			-1
#define USBSTATUS_NOLICENSE			-2


// voltage <--> data
#define DATA2VOLT(y)	(double)((y - 0x80) * 0.0768)		// = y * 20V / 268
#define VOLT2DATA(v)	(BYTE)((v / 0.0768) + 0x80)


/////////////////////////////////////////////////////////////
#pragma pack(push,1)		// for Visual C++ 6.0

typedef struct _WORDDATA {
	BYTE		ch1;
	BYTE		ch2;
} WORDDATA;

typedef struct {
	DWORD		marker;
	DWORD		cbSize;
	time_t		date;
	double		frequency;
	BYTE		channels;
	DWORD		length;
	DWORD		reserved0;
	DWORD		reserved1;
	DWORD		reserved2;
	DWORD		reserved3;
	DWORD		reserved4;
} DSO_HEADER;

typedef struct {
	DWORD		marker;
	DWORD		cbSize;
	time_t		date;
	double		frequency;
	BYTE		channels;
	WORD		enabled;
	char		names[16][16];
	WORD		chbits[16];
	BYTE		protocol[16];
	WORD		edgemode;
	DWORD		length;
	DWORD		reserved0;
	DWORD		reserved1;
	DWORD		reserved2;
	DWORD		reserved3;
	DWORD		reserved4;
} LGA_HEADER;

#pragma pack(pop)			// for Visual C++ 6.0
/////////////////////////////////////////////////////////////


#define SCOPE_MARKER_V1		(('1'<<24) | ('O'<<16) | ('S'<<8) | 'D')
#define LOGIC_MARKER_V0		(('0'<<24) | ('A'<<16) | ('G'<<8) | 'L')



#ifdef __cplusplus
extern "C" {
#endif


//****************************************************************
//	USB Functions
//****************************************************************

USBSCOPE_API int USB_RegisterDevice();

USBSCOPE_API int USB_FindDevice();

//----------------------------------------------------------------
// function:	Is USBScope device attached ?
// return:		(2) attached and ready to open, (1) attached, (-1) not found
//----------------------------------------------------------------
USBSCOPE_API int USB_Detect(int index);

//----------------------------------------------------------------
// function:	open USBScope device
// input:		hWnd: handle of main window
// return:		(1) connected, (0) delayed connect, (-1) not found
//----------------------------------------------------------------
USBSCOPE_API int USB_Open(HWND hWnd, int index);

//----------------------------------------------------------------
// function:	close USBScope device
//----------------------------------------------------------------
USBSCOPE_API void USB_Close();

//----------------------------------------------------------------
// function:	Is USBScope device opened ?
// return:		(TRUE) opened, (FALSE) not open
//----------------------------------------------------------------
USBSCOPE_API BOOL USB_IsOpen();

//----------------------------------------------------------------
// function:	Is USBScope device attached USB 2.0 High Speed 408Mbps ?
// return:		(TRUE) yes, (FALSE) no (USB 1.1 12MBps)
//----------------------------------------------------------------
USBSCOPE_API BOOL USB_IsHighSpeed();

//----------------------------------------------------------------
// function:	Get USB handle
// return:		Handle of USB opened
//----------------------------------------------------------------
USBSCOPE_API HANDLE USB_GetHandle();

USBSCOPE_API BOOL USB_ADChannel2_Enable(BOOL bADC2Enable);
USBSCOPE_API BOOL USB_IsADChannel2_Enable();

//----------------------------------------------------------------
// function:	Read USBScope data
// return:		(TRUE) OK, (FALSE) error
//----------------------------------------------------------------
USBSCOPE_API BOOL USB_Read(BYTE *readBuf, DWORD length);

USBSCOPE_API BOOL USB_ReadLoop(DWORD length, BYTE *pBufA, BYTE *pBufB, HANDLE hEvtA, HANDLE hEvtB, BOOL *pbStopFlag);

USBSCOPE_API char* USB_GetErrorString();

USBSCOPE_API double USB_HW_Frequency();
USBSCOPE_API int USB_HW_AnalogChannels();
USBSCOPE_API int USB_HW_DigitalChannels();
USBSCOPE_API char* USB_ModelName();

USBSCOPE_API void USB_Change_HW_Frequency(double frequency);
USBSCOPE_API int USB_Active_AnalogChannels();


//****************************************************************
//	Utility Functions
//****************************************************************

USBSCOPE_API double UTIL_GetAvailableSampleTime(DWORD buffer_size, int analog_channels, double capure_frequency);

// capture_time (micro second), analog_channels (USB_HW_AnalogChannels() = 1 or 2)
USBSCOPE_API DWORD UTIL_GetRequiredBytes(double capture_time, int analog_channels, double capure_frequency);

USBSCOPE_API void UTIL_Set_SW_Frequency(double frequency);

// nDownRate : 2,3,4,...
//			   S/W frequency = H/W frequency / nDownRate
//			   sample size = buflen / analog_channels / nDownRate
USBSCOPE_API void UTIL_DownSampling(BYTE *buffer, DWORD buflen, int analog_channels, int nDownRate);

USBSCOPE_API double UTIL_GetSampleTime(DWORD sampleIndex);

// If more than 4GB RAM, it only returns 4GB in maximum.
// Real free memory = temporal memory + UTIL_GetFreeMemory()
USBSCOPE_API DWORD UTIL_GetFreeMemory();


//****************************************************************
//	Data File Functions
//****************************************************************

USBSCOPE_API BOOL FILE_SaveScope(BYTE *buffer, DWORD buffLen, int analog_channels, double frequency, char* path);
USBSCOPE_API DWORD FILE_LoadScope(BYTE *pBuf, char* path);
USBSCOPE_API DSO_HEADER* FILE_GetScopeHeader();
USBSCOPE_API BOOL FILE_SaveLogic(BYTE *buffer, DWORD buffLen, int analog_channels, double frequency, char* path);
USBSCOPE_API DWORD FILE_LoadLogic(BYTE *pBuf, char* path);
USBSCOPE_API LGA_HEADER* FILE_GetLogicHeader();

#ifdef __cplusplus
}
#endif


#endif	//___USBSCOPE_DLL___

