#include "stdafx.h"
#include "test.h"
#include "testDlg.h"
#include <dbt.h>
#include "../usbscope_dll.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define BUF_LEN				(1024 * 2)

#define TIMERID_USB			1


/////////////////////////////////////////////////////////////////////////////
// CTestDlg dialog

CTestDlg::CTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTestDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTestDlg)
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTestDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTestDlg, CDialog)
	//{{AFX_MSG_MAP(CTestDlg)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_CONNECT, OnConnect)
	ON_BN_CLICKED(IDC_DISCONNECT, OnDisconnect)
	ON_BN_CLICKED(IDC_READ, OnReadUSB)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_INFO, OnDeviceInfo)
	ON_BN_CLICKED(IDC_FREEMEM, OnFreeMem)
	ON_BN_CLICKED(IDC_SAVE_DSO, OnSaveDso)
	ON_BN_CLICKED(IDC_SAVE_DSZ, OnSaveDsz)
	ON_BN_CLICKED(IDC_SAVE_TXT, OnSaveTxt)
	ON_BN_CLICKED(IDC_CHECK_AUTOCON, OnCheckAutocon)
	ON_BN_CLICKED(IDC_CHECK_ENCH2, OnCheckEnch2)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_DEVICECHANGE, OnDeviceChange)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTestDlg message handlers

BOOL CTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	m_bConnectCmd = FALSE;
	m_bAutoConnect = FALSE;
	m_bEnableAnalogChannel2 = TRUE;
	CheckDlgButton(IDC_CHECK_ENCH2, BST_CHECKED);

	EnableUI(FALSE);
	
	return TRUE;
}


LRESULT CTestDlg::OnDeviceChange(WPARAM wParam, LPARAM lParam)
{
	// A device has been added to or removed from the system.
	if(wParam == DBT_DEVNODES_CHANGED)
	{
		if(m_bAutoConnect && !m_bConnectCmd && !USB_IsOpen())
		{
			int		ret;
			ret = USB_RegisterDevice();
			if(ret > 0)
			{
				GetDlgItem(IDC_CONNECT)->EnableWindow(FALSE);
				m_bConnectCmd = TRUE;
				SetTimer(TIMERID_USB, 1000, NULL);
			}
		}
	}
	// A device or piece of media has been removed.
	else if(wParam == DBT_DEVICEREMOVECOMPLETE)
	{
		PDEV_BROADCAST_HDR bcastHdr = (PDEV_BROADCAST_HDR)lParam;

		if(bcastHdr->dbch_devicetype == DBT_DEVTYP_HANDLE)
		{
			PDEV_BROADCAST_HANDLE pDev = (PDEV_BROADCAST_HANDLE)lParam;
		
			// USBScope removed!
			if(USB_IsOpen() && pDev->dbch_handle == USB_GetHandle())
			{
				USB_Close();
				EnableUI(FALSE);
			}
		}
	}

	return 1;
}


void CTestDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	KillTimer(TIMERID_USB);
	
	if(USB_IsOpen())
		USB_Close();
}


void CTestDlg::OnCheckAutocon() 
{
	m_bAutoConnect = IsDlgButtonChecked(IDC_CHECK_AUTOCON);
}


void CTestDlg::OnCheckEnch2() 
{
	m_bEnableAnalogChannel2 = IsDlgButtonChecked(IDC_CHECK_ENCH2);
	if(USB_ADChannel2_Enable(m_bEnableAnalogChannel2))
	{
		GetDlgItem(IDC_SAVE_DSO)->EnableWindow(FALSE);
		GetDlgItem(IDC_SAVE_DSZ)->EnableWindow(FALSE);
		GetDlgItem(IDC_SAVE_TXT)->EnableWindow(FALSE);
	}
	else
		AfxMessageBox("Error");
}


void CTestDlg::OnConnect() 
{
	int		ret;
	
	// 1. Register USB device
	ret = USB_RegisterDevice();
	if(ret > 0)
	{
		GetDlgItem(IDC_CONNECT)->EnableWindow(FALSE);
		m_bConnectCmd = TRUE;
		SetTimer(TIMERID_USB, 1000, NULL);
		return;
	}

	// 2. Device registered or No device
	ret = USB_Open(m_hWnd, 0);
	if(ret == USBSTATUS_CONNECTED)
	{
		FirstConnect();
	}
	else if(ret < 0)
	{
		if(ret == USBSTATUS_NOLICENSE)
			AfxMessageBox("License file not found!", MB_ICONSTOP);
		else
			AfxMessageBox("USBScope not found!", MB_ICONINFORMATION);
	}
}


void CTestDlg::OnTimer(UINT nIDEvent) 
{
	if(nIDEvent == TIMERID_USB)
	{
		if(m_bConnectCmd && (USB_Detect(0) == USBSTATUS_ATTACHED))
		{
			m_bConnectCmd = FALSE;
			KillTimer(TIMERID_USB);
			
			if(USB_Open(m_hWnd, 0) == USBSTATUS_CONNECTED)
			{
				FirstConnect();
			}
			else
			{
				GetDlgItem(IDC_CONNECT)->EnableWindow(TRUE);
			}
		}
	}
	
	CDialog::OnTimer(nIDEvent);
}


void CTestDlg::FirstConnect()
{
	EnableUI(TRUE);

	if(USB_HW_AnalogChannels() == 1)
	{
		m_bEnableAnalogChannel2 = FALSE;
		CheckDlgButton(IDC_CHECK_ENCH2, BST_UNCHECKED);
		GetDlgItem(IDC_CHECK_ENCH2)->EnableWindow(FALSE);
	}

	if(!USB_IsHighSpeed())
	{
		AfxMessageBox("Connected at USB 1.1 12Mbps Full Speed\n"
					"USBScope requires USB 2.0 480Mbps High Speed!");
	}
}


void CTestDlg::EnableUI(BOOL bEn)
{
	GetDlgItem(IDC_CONNECT)->EnableWindow(!bEn);
	GetDlgItem(IDC_DISCONNECT)->EnableWindow(bEn);
	GetDlgItem(IDC_READ)->EnableWindow(bEn);
	GetDlgItem(IDC_INFO)->EnableWindow(bEn);
	GetDlgItem(IDC_CHECK_ENCH2)->EnableWindow(bEn);

	if(!bEn)
	{
		GetDlgItem(IDC_SAVE_DSO)->EnableWindow(FALSE);
		GetDlgItem(IDC_SAVE_DSZ)->EnableWindow(FALSE);
		GetDlgItem(IDC_SAVE_TXT)->EnableWindow(FALSE);
	}
}


void CTestDlg::OnDisconnect()
{
	if(USB_IsOpen())
		USB_Close();

	EnableUI(FALSE);
}


BYTE	usbBuf[BUF_LEN];

void CTestDlg::OnReadUSB()
{
	if(USB_IsOpen())
	{
		if(USB_Read(usbBuf, BUF_LEN))
		{
			GetDlgItem(IDC_SAVE_DSO)->EnableWindow(TRUE);
			GetDlgItem(IDC_SAVE_DSZ)->EnableWindow(TRUE);
			GetDlgItem(IDC_SAVE_TXT)->EnableWindow(TRUE);
		}
		else
			AfxMessageBox("Error");
	}
}


void CTestDlg::OnSaveDso() 
{
	FILE_SaveScope(usbBuf, BUF_LEN, USB_Active_AnalogChannels(),
					USB_HW_Frequency(), "capture.dso");
}


void CTestDlg::OnSaveDsz() 
{
	FILE_SaveScope(usbBuf, BUF_LEN, USB_Active_AnalogChannels(),
					USB_HW_Frequency(), "capture.dsz");
}


void CTestDlg::OnSaveTxt() 
{
	FILE	*fp;
	DWORD	SampleCnt;
	
	fp = fopen("capture.txt", "wt");
	if(fp == NULL)	return;

	if(USB_Active_AnalogChannels() == 2)
	{
		SampleCnt = BUF_LEN / 2;

		fprintf(fp, "Time(us)\tCH1(V)\tCH2(V)\n");

		double		v1, v2;
		WORDDATA	*pWord = (WORDDATA*)usbBuf;
		for(DWORD i=0; i<SampleCnt; i++)
		{
			v1 = DATA2VOLT(pWord->ch1);
			v2 = DATA2VOLT(pWord->ch2);
			pWord++;

			fprintf(fp, "%.3f\t%.3f\t%.3f\n", UTIL_GetSampleTime(i), v1, v2);
		}
	}
	else
	{
		SampleCnt = BUF_LEN;

		fprintf(fp, "Time(us)\tCH1(V)\n");

		double	v;
		BYTE	*pByte = (BYTE*)usbBuf;
		for(DWORD i=0; i<SampleCnt; i++)
		{
			v = DATA2VOLT(*pByte);
			pByte++;

			fprintf(fp, "%.3f\t%.3f\n", UTIL_GetSampleTime(i), v);
		}
	}

	fclose(fp);
}


void CTestDlg::OnDeviceInfo() 
{
	if(USB_IsOpen())
	{
		CString		str;

		str.Format("Model: %s\r\n"
				"H/W frequency: %0.f Hz\r\n"
				"Analog Channels: %d\r\n"
				"Digital Channels: %d\r\n",
				USB_ModelName(),
				USB_HW_Frequency(),
				USB_HW_AnalogChannels(),
				USB_HW_DigitalChannels());

		AfxMessageBox(str);
	}
}


void CTestDlg::OnFreeMem() 
{
	CString		str;
	DWORD		ram;

	ram = UTIL_GetFreeMemory();
	if(ram > 1073741824)	str.Format("%.1f GB", ram / 1073741824.0);
	else if(ram > 1048576)	str.Format("%.1f MB", ram / 1048576.0);
	else if(ram > 1024)		str.Format("%.1f KB", ram / 1024.0);
	else					str.Format("%.1f Bytes", ram);
	str += " free!";
	AfxMessageBox(str);
}

